//############################################################################//
//             Copyright (c) 2006, by Deluxe-Menu.com
//             Deluxe Tuner script
//             http://deluxe-menu.com
//             Programming by Shakhmatov Nik
//             E-mail: cs@deluxe-menu.com
//############################################################################//

var dm_paramPrefix = '@parameter-';

var dm_ID_paramName = '@paramName';
var dm_ID_value     = '@value';
var dm_ID_hint      = '@hint';
var dm_ID_id        = '@id';

var dm_paramTypes = ['integer', 'integer-nn', 'integer-percent', 'percent',
                      'boolean', 'string',     'image', 'font',
                      'set',     'set-add',    'color', 'effect',
                      'section', 'separator',

                      'color-array',  'color-array-item',
                      'image-array',  'image-array-item',
                      'string-array', 'string-array-item',
                      'set-array',    'set-array-item',
                      'font-array',   'font-array-item'];

var dm_paramTypeTmpls = [];


var idName  = new RegExp(dm_ID_paramName, 'g');
var idValue = new RegExp(dm_ID_value,     'g');
var idHint  = new RegExp(dm_ID_hint,      'g');
var idId    = new RegExp(dm_ID_id,        'g');
var idBreak = new RegExp('>>', 'g');


//############################################################################//
//  Functions for parameters creation
//############################################################################//

function dm_readParamTemplates()
// Saves parameter templates
{
  var obj;
  for (var i=0; i<dm_paramTypes.length; i++)
  {
      obj = document.getElementById(dm_paramPrefix+dm_paramTypes[i]);
      dm_paramTypeTmpls[i] = (obj?obj.innerHTML:'');
  }
}


function dm_getTmplForType(typeName)
// Returns template for specified parameter type
{
  if (typeName=='undefined') return '';
  for (var i=0; dm_paramTypes[i]!=typeName && i<dm_paramTypes.length; i++) continue;
  if (dm_paramTypes[i]!=typeName)
  {
      //alert('There is no such type:' + String.fromCharCode(13) + typeName);
      return '';
  }
  else
      return dm_paramTypeTmpls[i];
}


function dm_buildParam(pHTML, pName, pType, pValue)
// Creates complete code from template for specified parameter's type
{
  var s='';
  switch (pType)
  {
    case 'section':
        var idIcon = new RegExp('@image', 'g');
        pHTML = pHTML.replace(idIcon, pValue+'.gif');
    break;
    

    case 'set-add':
    case 'set':
        if (b_IE)
        {
            if (b_VER>=5.5)
                var idSetValue = new RegExp('<OPTION value=@'+pType+'value selected>', 'i');
            else
                var idSetValue = new RegExp('<OPTION selected value=@'+pType+'value>', 'i');
        }
        else
            if (b_SAF) var idSetValue = new RegExp('<OPTION value="@'+pType+'value" selected=""></OPTION>', 'i');
            else
                var idSetValue = new RegExp('<option value="@'+pType+'value" selected="selected">', 'i');

        var values = pValue.split(',');
        for (var i=0; i<values.length; i++) s += '<option value='+i+'>'+values[i];

        if (pType=='set-add') s += '<option value='+(i+1)+'>custom...';

        pHTML = pHTML.replace(idSetValue, s);
    break;


    case 'color-array':
    case 'image-array':
    case 'set-array':
    case 'string-array':
    case 'font-array':
        var itemTmpl  = dm_getTmplForType(pType+'-item');
        var itemsTmpl = '';
        var _itemTmpl;


        for (var i=0; i<pValue.length; i++)
        {
            _itemTmpl = itemTmpl;
            _itemTmpl = _itemTmpl.replace(idId, pName+'_item'+i+'_id');

            if (pType=='set-array')
                _itemTmpl = dm_buildParam(_itemTmpl, '', 'set', pValue[i]);
            else
                if (b_IE) _itemTmpl = _itemTmpl.replace(idValue, "'"+pValue[i]+"'");
                else      _itemTmpl = _itemTmpl.replace(idValue, ""+pValue[i]+"");

                

            itemsTmpl += _itemTmpl;
        }

        var idItem = new RegExp(dm_paramPrefix+pType+'-item', 'g');
        pHTML = pHTML.replace(idItem, itemsTmpl);

    break;
  }

  return pHTML;
}


function dm_showHint(pInd)
// Returns/shows hint text for specified parameter  (used for parameters window)
{
  var idBr = new RegExp('>>', 'g');
  if (dmDeluxeTuner) window.status = '@showHint:Parameter: ' + dm_getParam(pInd,0) + String.fromCharCode(13) + '--------------------------' + String.fromCharCode(13) + dm_getParam(pInd,3).replace(idBr, String.fromCharCode(13));
  else
      alert('Parameter: ' + dm_getParam(pInd,0) + '\n--------------------------\n' + dm_getParam(pInd,3).replace(idBr, '\n'));
}


function dm_showHint2(text)
// Returns/shows hint text for specified parameter (used for item parameters window)
{
  var idBr = new RegExp('>>', 'g');
  if (dmDeluxeTuner) window.status = '@showHint:'+text.replace(idBr, String.fromCharCode(13));
  else
       alert(text.replace(idBr, '\n'));
}


function dm_buildParamList()
// Creates completed parameters content
{
  var s='', ps='', hint='', hintBtn='', helpURL='';
  var pName, pType, pValue;

  for (var i=0; i<dm_tunerParams.length; i++)
  {
      pName  = dm_getParam(i,0);
      pType  = dm_getParam(i,1);
      pValue = dm_getParam(i,2);
      hint   = dm_getParam(i,3).replace(idBreak, String.fromCharCode(13));
      ps = dm_getTmplForType(pType);

      if (pType=='section' && i>0) ps = '</div>' + ps;            // close section div

      hintBtn = (pType!='section' && pType!='separator')?'<span class="hintButton" onClick="dm_showHint('+i+');">&nbsp;?&nbsp;</span>&nbsp;':'';
      helpURL = (dm_getParam(i,4)?'<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="'+dm_getParam(i,4)+'" target="_blank" title="Click to show additional information.">Additional info</a>':'');
      
      ps = ps.replace(idName,  hintBtn + pName + helpURL);
      
      if (b_IE) ps = ps.replace(idValue, "'"+pValue+"'");
      else      ps = ps.replace(idValue, ""+pValue+"");
      
      if (pType=='section')                                       // param is section
      {
          ps = ps.replace(idId,   'section'+i+'_id');
          ps = ps.replace(idHint, (hint ? 'minus' : 'plus'));     // select expand button image for section
      }
      else
      {
          ps = ps.replace(idId,    pName+'_id');
          ps = ps.replace(idHint,  '"'+hint+'"');
      }
      ps = dm_buildParam(ps, pName, pType, pValue);


      if (pType=='section') ps += '<div id="section'+i+'_id" style="width: 100%; display:'+(hint?'block':'none')+';'+ ( (b_IE && !b_MAC) ? 'filter:blendTrans(duration=0.3)' : '') + '">';   // open section div
      if (i+1==dm_tunerParams.length) ps += '</div>';             // close section div

      s += ps;
  }
  
  s += '<br><br>';
  
  // Create file input for HTML version of Tuner. It'll be used for files choice
  //if (!dmDeluxeTuner) s += '<input type=file id="dmFile" style="display:none"  value="">';
  
  document.body.innerHTML = s;
}


//############################################################################//
//  Initial functions
//############################################################################//

var canModify = true;

function dm_Modified()
{
  if (canModify)
  {
      if (dmDeluxeTuner) window.status = '@modified:null';
      else
          if (typeof(dmStylesPage)=='undefined')                   // called from menu parameters page
          {
              parent.frames[4].window.startPreviewTimer();
          }
          else                                                     // called from individual styles parameters page
          {
              parent.frames[2].window.updateStyleParameters();
              parent.opener.parent.frames[4].window.startPreviewTimer();
          }
  }
}


function dm_setChangeEvents(tagName)
// Assigns events for specified objects
{
  var objs = document.getElementsByTagName(tagName);

  // DO NOT use objs[i].onpropertychange instead of attachEvent for Deluxe Tuner,
  // because it causes problems with loading/saving of individual styles.
  if (b_IE && !b_MAC)
      for (var i=0; i<objs.length; i++) objs[i].attachEvent('onpropertychange', dm_Modified);
  else
      for (var i=0; i<objs.length; i++)
      {
          switch (objs[i].tagName)
          {
              case 'INPUT':  if (objs[i].type.toUpperCase()=='TEXT')
                             {
                                 objs[i].onkeyup = dm_Modified;
                             }
              break;
              case 'SELECT': objs[i].onchange = dm_Modified;
              break;
          }
      }
}


function dm_reCreateParams()
// Re-builds parameters page
{
  dm_buildParamList();
  dm_setChangeEvents('INPUT');
  dm_setChangeEvents('SELECT');
}


function dm_initialize()
// Initializes page
{
  dm_readParamTemplates();
  dm_reCreateParams();
}


function dm_getParam(paramInd, fieldInd)
{
  return (typeof(dm_tunerParams[paramInd])!='undefined')?dm_tunerParams[paramInd][fieldInd]:'';
}


//############################################################################//
//  Functions for page
//############################################################################//

function dm_setaddChange(selObj)
// Executed for <select> onChange event
{
  with (selObj)
      document.getElementById(id+'_edit').style.display = (selectedIndex==options.length-1)?'':'none';
}


function dm_changeParamBtn(obj, className)
{
  obj.className = className;
}


function dm_setParam_setadd(pName, pValue)
// Sets <select> value for types: set, set-add
{
  var selObj  = document.getElementById(pName+'_id');
  var editObj = document.getElementById(selObj.id+'_edit');

  for (var i=0; i<selObj.options.length; i++)
      if (selObj.options[i].text==pValue)
      {
          selObj.selectedIndex = i;
          if (editObj)
          {
              editObj.style.display = 'none';
              editObj.value = '';
          }
          return;
      }

  selObj.selectedIndex = selObj.options.length-1;
  if (editObj)
  {
      editObj.value = pValue;
      editObj.style.display = '';
  }
}


function dm_getParam_setadd(pName)
// Returns parameter value from object for types: set, set-add
{
  var selObj  = document.getElementById(pName+'_id');
  var editObj = document.getElementById(selObj.id+'_edit');

  if (selObj.selectedIndex == selObj.options.length-1 && editObj)
      return editObj.value;
  else
      return selObj.options[selObj.selectedIndex].text;
}


function dm_expandSection(sid)
// Expands section and changes image for expand-button
{
  var sObj = document.getElementById(sid);
  var img  = document.getElementById(sid+'_img');
  if (sObj.style.display)
  {
      img.src = '../images/minus.gif';

      if (b_IEPC)
      {
          sObj.filters[0].apply();
          sObj.style.display = '';
          sObj.filters[0].play();
      }
      else
          sObj.style.display = '';
  }
  else
  {
      sObj.style.display = 'none';
      img.src = '../images/plus.gif';
  }
}


